# -*- coding: UTF-8 -*-
import re
import traceback

from com.huawei.ism.tool.obase.exception import ToolException


def execute(context):
    """
    获取交换机信息
    :param context: 上下文
    :return:
        name（设备名称）----Value
        type（设备类型）----Value
        sn（设备序列号）----Value
        version（产品版本号）----Value
    """

    dev_info = {}
    try:
        cli_ret = context.get('SSH').execCmd("display version")
        if cli_ret:
            model_search_obj = re.search("CE\d{4}", cli_ret)
            model = model_search_obj.group(0) if model_search_obj else ""

            ver_search_obj = re.search(
                "V\d{3}R\d{3}C\d{2}(SPC\d{3})?", cli_ret)
            version = ver_search_obj.group(0) if ver_search_obj else ""

            dev_info = {
                'version': version,
                'name': "IP Scale-Out",
                'type': model,
                'sn': context['dev'].ip  # 交换机无SN，暂用IP替代
            }
    except (Exception, ToolException):
        context.get("logger").error(
            "[IPScaleOUT script]:" + str(traceback.format_exc()))
    return dev_info
